(function($){
    'use strict';

    $(document).ready( function(){
    	var modulaSliders = $( '.modula-slider' );

    	if ( modulaSliders.length > 0 ) {
    		$.each( modulaSliders, function(){
    		 	var modulaID = $( this ).attr( 'id' ),
            		config   = $( this ).data( 'config' ),
                    nav      = $(this).find( '.modula-slider-nav' ),
                    main     = $(this).find( '.modula-items' );

            	main.slick( config.slider_settings );

                if ( nav.length ) {

                    var navConfig = nav.data( 'config' ),
                        currentSlide = main.slick( 'slickCurrentSlide' );

                    nav.on('init', function(event, slick) {
                        nav.find( '.slick-slide[data-slick-index="' + currentSlide + '"]' ).addClass('is-active');
                    })

                    nav.slick( navConfig );

                    main.on('afterChange', function(event, slick, currentSlide) {
                        nav.slick('slickGoTo', currentSlide);
                        var currrentNavSlideElem = '.slick-slide[data-slick-index="' + currentSlide + '"]';
                        nav.find('.slick-slide.is-active').removeClass('is-active');
                        nav.find( currrentNavSlideElem ).addClass('is-active');
                    });

                    nav.on('click', '.slick-slide', function(event) {
                        event.preventDefault();
                        var goToSingleSlide = $(this).data('slick-index');
                        main.slick('slickGoTo', goToSingleSlide);
                    });

                }

                // Lightbox functionality
			    if ( 'fancybox' === config.lightbox ) {

				    main.on( 'click', '.modula-item-link:not( .modula-simple-link )', function ( e ) {

					    e.preventDefault();

					    var items = main.find( '.modula-item' ).filter( ':not( .modula-simple-link )' ),
					        links = jQuery.map( items, function ( o ) {
						        var link  = jQuery( o ).find( '.modula-item-link' ),
						            image = jQuery( o ).find( '.pic' );
						        if ( link.length > 0 ) {
							        return {
								        'src':  link.attr( 'href' ),
								        'opts': {
									        'caption':  link.data( 'caption' ),
									        'alt':      image.attr( 'alt' ),
									        'thumb':    link.attr( 'data-thumb' ),
									        'image_id': link.attr( 'data-image-id' )
								        }
							        }
						        }
					        } );

					    var index = items.index( jQuery( this ).parents( '.modula-item' ) );

					    config.lightboxOpts['beforeLoad'] = function () {
						    jQuery( document ).trigger( 'modula_fancybox_lightbox_before_load', [ main, this ] );
					    };
					    config.lightboxOpts['afterLoad'] = function () {
						    jQuery( document ).trigger( 'modula_fancybox_lightbox_after_load', [ main, this ] );
					    };
					    config.lightboxOpts['beforeShow'] = function () {
						    jQuery( document ).trigger( 'modula_fancybox_lightbox_before_show', [ main, this ] );
					    };
					    config.lightboxOpts['afterShow'] = function () {
						    jQuery( document ).trigger( 'modula_fancybox_lightbox_after_show', [ main, this ] );
					    };
					    config.lightboxOpts['beforeClose'] = function () {
						    jQuery( document ).trigger( 'modula_fancybox_lightbox_before_close', [ main, this ] );
					    };
					    config.lightboxOpts['afterClose'] = function () {
						    jQuery( document ).trigger( 'modula_fancybox_lightbox_after_close', [ main, this ] );
					    };
					    config.lightboxOpts['onInit'] = function () {
						    jQuery( document ).trigger( 'modula_fancybox_lightbox_on_init', [ main, this ] );
					    };
					    config.lightboxOpts['onActivate'] = function () {
						    jQuery( document ).trigger( 'modula_fancybox_lightbox_on_activate', [ main, this ] );
					    };
					    config.lightboxOpts['onDeactivate'] = function () {
						    jQuery( document ).trigger( 'modula_fancybox_lightbox_on_deactivate', [ main, this ] );
					    };

					    if(modulacheckDevice(config)){
						    jQuery.modulaFancybox.open( links, config.lightboxOpts, index );
					    }

				    } );
			    }
    		});
    	}
    });

})( jQuery );